/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.DeleteException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.interfaces.IDAOContext;
import com.quantumdata.sct.dao.interfaces.IDao;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.ObjectFactory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;

public abstract class AbstractXMLStorageDAO
implements IDao {
    private Marshaller _mx;
    private Unmarshaller unc;
    protected Map daoCollection = Collections.synchronizedMap(new LinkedHashMap());
    protected Map voCollection = Collections.synchronizedMap(new LinkedHashMap());
    protected boolean defaultCache = false;
    protected String storageName;
    protected IDAOContext _ctx;
    protected JAXBContext _jc;
    protected boolean initialize = false;
    protected Object daoObject;
    protected ObjectFactory factory = new ObjectFactory();
    protected Validator validator = null;

    public void initialize(IDAOContext iDAOContext) throws DAOException {
        this._ctx = iDAOContext;
        String string = iDAOContext.getEnvironment().getProperty("JAXBPACKAGEROOT");
        this.setStorageName(iDAOContext.getStorageName());
        try {
            this._jc = JAXBContext.newInstance((String)string);
            this.validator = this._jc.createValidator();
            this.read();
            this.readCallback();
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to get JAXB Context", null, exception);
        }
    }

    protected Unmarshaller getUnmarshaller() throws Exception {
        if (this.unc == null) {
            this.unc = this._jc.createUnmarshaller();
        }
        return this.unc;
    }

    protected Marshaller getMarshaller() throws Exception {
        if (this._mx == null) {
            try {
                this._mx = this._jc.createMarshaller();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                throw exception;
            }
        }
        return this._mx;
    }

    public Object read() throws Exception {
        Unmarshaller unmarshaller = this.getUnmarshaller();
        this.daoObject = unmarshaller.unmarshal((InputStream)new FileInputStream(this.getStorageName()));
        return this.daoObject;
    }

    protected void write(Object object) throws Exception {
        if (!this.initialize) {
            throw new Exception("Not initialized");
        }
        Marshaller marshaller = this.getMarshaller();
        marshaller.marshal(object, (OutputStream)new FileOutputStream(this.getStorageName()));
    }

    public abstract void readCallback() throws DAOException;

    public final void flush() throws DAOException {
        try {
            this.validate();
            this.write(this.daoObject);
            this.voCollection.clear();
            this.readCallback();
        }
        catch (Throwable throwable) {
            throw new DAOException("Flush Error", null, throwable);
        }
    }

    protected void validate() throws Exception {
        if (this.validator == null) {
            this.validator = this._jc.createValidator();
        }
        this.validator.validate(this.daoObject);
    }

    public IPersistable read(Object object) throws ReadException {
        IPersistable iPersistable = null;
        if (object == null || !this.initialize) {
            throw new ReadException("Invalid Key or Initialization exception. Key = " + object);
        }
        try {
            iPersistable = this.readVOCollection(object);
            if (iPersistable == null) {
                iPersistable = this.getValueObjectForKey(object);
                if (this.defaultCache && iPersistable != null) {
                    this.voCollection.put(object, iPersistable);
                }
                if (iPersistable == null) {
                    throw new IllegalArgumentException("Invalid Key. Key not found");
                }
            }
        }
        catch (Throwable throwable) {
            this.log(throwable.getMessage());
            throw new ReadException("Error in Read by key " + object + ". Explanation = " + throwable.getMessage(), null, throwable);
        }
        return iPersistable;
    }

    private IPersistable readVOCollection(Object object) {
        IPersistable iPersistable = null;
        if (this.voCollection.containsKey(object)) {
            iPersistable = (IPersistable)this.voCollection.get(object);
        }
        return iPersistable;
    }

    protected abstract IPersistable getValueObjectForKey(Object var1) throws CreateException;

    public IPersistable[] readAll() throws ReadException {
        IPersistable[] iPersistableArray;
        if (!this.initialize) {
            throw new ReadException("Not initialized");
        }
        try {
            iPersistableArray = this.findByAll();
        }
        catch (Throwable throwable) {
            throw new ReadException("Failed to read all", null, throwable);
        }
        return iPersistableArray;
    }

    protected abstract IPersistable[] findByAll() throws Exception;

    public void addToCache(IPersistable iPersistable, Object object) {
        if (iPersistable != null && object != null && this.voCollection.containsKey(object)) {
            this.voCollection.put(object, iPersistable);
        }
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String string) {
        this.storageName = string;
    }

    public void update(IPersistable iPersistable) throws UpdateException {
        block4: {
            if (!this.initialize || iPersistable == null) {
                throw new UpdateException("Not initialized and or Invalid persistent Object");
            }
            try {
                if (!iPersistable.isDirty() || iPersistable.isNew()) break block4;
                if (this.daoCollection.containsKey(iPersistable.getId())) {
                    this.updateObject(iPersistable);
                    this.flush();
                    this.readCallback();
                    break block4;
                }
                throw new Exception("Id not found in dao collection", null);
            }
            catch (Throwable throwable) {
                throw new UpdateException("Unable to value object", null, throwable);
            }
        }
    }

    public final void updateAll(IPersistable[] iPersistableArray) throws UpdateException {
        if (!this.initialize) {
            throw new UpdateException("Not initialized");
        }
        int n = iPersistableArray.length;
        int n2 = 0;
        try {
            while (n2 < n) {
                this.updateObject(iPersistableArray[n2]);
            }
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new UpdateException(exception.getMessage());
        }
    }

    protected abstract void updateObject(IPersistable var1) throws Exception;

    public abstract Object getUniqueKey(Object var1);

    public abstract Object getUniqueKey();

    public final void remove(IPersistable iPersistable) throws DeleteException {
        try {
            Object object = iPersistable.getId();
            this.removeByPrimaryKey(object);
            this.flush();
            this.readCallback();
        }
        catch (Throwable throwable) {
            throw new DeleteException("Could not delete", null, throwable);
        }
    }

    protected abstract void removeByPrimaryKey(Object var1) throws DAOException;

    public void add(IPersistable iPersistable) throws CreateException {
        this.add(iPersistable, 0);
    }

    public abstract void add(IPersistable var1, int var2) throws CreateException;

    public IDAOContext getContext() {
        return this._ctx;
    }

    public void setContext(IDAOContext iDAOContext) {
        this._ctx = iDAOContext;
    }

    protected void log(String string) {
        System.out.println(string);
    }
}

